/* integer.h */

#ifndef INT__H
#define INT__H

#include "udata.h"
#include "units.h"

class dc_int : public dc_udata {
protected:
  long int val;

public:
  /* creates temporary */
  dc_int( const long int I = 0 );

  dc_int( const long int I, const string &label, dc_node *parent = nil );

  /* inherited functions */
  const dc_type type( void ) const { return Int_t; }
  string type_string( void ) const { return string( "int" ); }

  /* input, output, and assignment operators */
  dc_int &operator=( dc_data &D );
  dc_int &operator=( const long int d );

  ostream &display( ostream &stream = cout ){ return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_int &I ) { 
    return I.display_c( stream ); 
  }
  friend istream &operator>>( istream &stream, dc_int &I );

  /* functions to access val */
  long int get( void ) const { return val; }
  double get_real( void ) const { return ( double )val; }
  void set( const long int v ) { val = v; }

  dc_label *duplicate( dc_node *parent ) const;
};

#endif



