/* id_lookup.h */

#ifndef ID_LOOKUP__H
#define ID_LOOKUP__H

#include "id.h"
#include <LEDA/queue.h>

struct search_node;

void search_expand( const dc_label *id, queue<search_node *> &search_queue );

/* no search will return an invisible or dormant component unless search_all is
   true */
bool search_eligible( const dc_label *l );

/* return closest matching label with path lbl or nil on failure */
dc_label *search( cstring lbl, dc_label *start = nil, 
		  const bool search_all = false ); 

/* returns closest label with sub_type T and path lbl or nil on failure */
dc_label *t_search( cstring lbl, const dc_type T, dc_label *start = 
		    nil, const bool search_all = false );
/* returns closest label with sub_type != T and path lbl or nil on failure */
dc_label *nt_search( cstring lbl, const dc_type T, dc_label *start =
		     nil, const bool search_all = false );
/* returns closest label matching a given criterion.   criterion will not be
   passed a nil argument */
dc_label *fit_search( cstring label, bool( const dc_label * ), 
		      dc_label * origin, const bool see_all = false );

/* returns label if any with path label()+lbl or nil on failure */
dc_label *lookup_relative( cstring lbl, dc_label *start = nil, 
			   const bool search_all = false );

/* following return nil if global label does not exist */
dc_label *lookup( cstring global_label, const bool search_all = false );
dc_label *lookup( const tag globalTag );

/* returns tag_error if not in component */
tag lookup_tag( cstring global_label, const bool search_all = false );

/* true if label already exists as child of parent or at root if no parent */
bool label_exists( cstring label, const dc_node *parent = nil );

#endif
