/* ga_optimizer.h */

#ifndef GA_OPTIMIZER__H
#define GA_OPTIMIZER__H

#include "ga_input.h"
#include "ga_iface.h"

class ga_optimizer : public ga {
protected:
  ga_input_list inputs;
  
  bool init( void );
  bool run( void );
  bool finish( void );
  bool output( void );

  void cleanup( void );

  double Evaluate( const StdBitString &bstring );
  double Simulate( void );
  double Step( double stepSize );

  void Reset( void );


public:
  ~ga_optimizer( void );

  void add_input( ga_input &i ) { inputs.add_input( i ); }
  void clear_inputs( void );

  string type_string( void ) const { return string( "ga optimizer" ); }
};

#endif
