/* cor_pipe.cc */

#include "cor_pipe.h"

dc_cor_pipe::dc_cor_pipe( cpipe_type cpt, cstring label, dc_component *parent ){
  shape = nil;
  set_both( label, parent ); 
  set_pipe_type( cpt );
}

int dc_cor_pipe::rehash( dep_list &dl ) {
  int nerrors = dc_element::rehash( dl );

  dc_node *parent = get_parent();
  shape = nil;
  if( parent != nil ) {
    dc_label *id = parent->lookup_child( coriolis_shape_label );
    if( id != nil ) {
      switch( id->type() ) {
      case Element_t :
	if( ( ( dc_element * )id )->get_rtype() == Shape_t ) {
	  shape = ( dc_shape * )( ( dc_element * )id )->get();
	}
	break;
      case Shape_t :
	shape = ( dc_shape * )id;
	break;
      default :;
      }
    }
  }

  if( shape == nil ) {
    dc_trace( TRACE_WARNING ) {
      cerr << "dc_cor_pipe::rehash -- failed to match shape to pipe\n";
    }
    nerrors++;
  }

  return nerrors;
}
