/* buf_info.cc */

#include "buf_info.h"

buf_info::buf_info( void ) {
  char_pos = len = 0;
  prev_tag = next_tag = tag_error;
}

buf_info::buf_info( const string &FName, int Char_Pos, int Len, tag P, tag N ) {
  set( FName, Char_Pos, Len, P, N );
}


void buf_info::set( const string &FName, int Char_Pos, int Len, tag P, tag N ) {
  filename = FName;
  char_pos = Char_Pos;
  len = Len;
  prev_tag = P;
  next_tag = N;
}

string buf_info::to_string( void ) const {
  if( filename.length() ) {
    string s = "<\"" + filename + string( "\":%d-%d", char_pos, 
					  char_pos + len - 1 );
    if( prev_tag != tag_error ) s += string( ", prev tag: %d", prev_tag );
    if( next_tag != tag_error ) s += string( ", next tag: %d", next_tag );
    return s += ">";
  } 
  return "";
}

ostream &operator<<( ostream &stream, const buf_info &B ) {
  return stream << B.to_string();
}

