/* bool.h */

#ifndef BOOL__H
#define BOOL__H

#include "data.h"

/* boolean data primitive */
class dc_boolean : public dc_data {
private:
  bool val;
public:
  /* creates temporary */
  dc_boolean( const bool b = false ); 

  dc_boolean( const bool b, const string &label, dc_node *parent = nil ); 

  /* inherited functions */
  const dc_type type( void ) const { return Boolean_t; }
  string type_string( void ) const { return string( "boolean" ); }

  /* operators */
  dc_boolean &operator=( const bool b );
  dc_boolean &operator=( dc_data &D );
  dc_boolean &operator&&( dc_boolean &B );
  dc_boolean &operator||( dc_boolean &B );
  dc_boolean &operator!( void );
  dc_boolean &operator^( dc_boolean &B );
  dc_boolean &operator==( dc_boolean &B );
  dc_boolean &operator!=( dc_boolean &B );
  friend dc_data &If( dc_boolean &B, dc_data &Then, dc_data &Else );

  ostream &display( ostream &stream = cout ) { return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_boolean &B ) {
    return B.display_c( stream );
  }
  friend istream &operator>>( istream &stream, dc_boolean &B );
  
  /* functions to access val */
  bool get( void ) const { return val; }
  void set( const bool b ) { val = b; }
  void set( const dc_boolean &B ) { val = B.get(); }

  dc_label *duplicate( dc_node *parent ) const;
};

#endif
