
Component General{
  Component time {
    
  }
  
  Component geometry {
    
    Posedist (p1 ,p2) = ((p1[0]-p2[0])^2 + (p1[1]-p2[1])^2 + (p1[2]-p2[2])^2)^0.5;
    
  }
  
  Component Light {
    speed = 3E8; /* m/s */
    lambda(freq) = speed/freq;
    freq(lambda) = speed/lambda;
  }

  Component radiation {
    sigma = 5.78E-8; /* Stefan Boltzman constant, W/m^2/K^4 */
    Q(e,A,T) = sigma*e*A*T^4;
  }

  Component conduction {
    /* if dt > 0, inside is hotter >= outflow */

    linear { 
      Q(k,dT,dx,A) = k*A/dx*dT;
    }

    cylinder { /* Ri: inner radius or dia */
      Q(k,dT,dx,Ro,Ri,) = 2*Pi*k*dx*dT/ln(Ro/Ri);
    }

    sphere { 
      Q(k,dT,Ro,Ri) = 4*Pi*k*Ri*Ro*dT/(Ro-Ri);
    }
  } /* Conduction */

} /* General */
