/* communication-link.txt */

/* everything in here is in dB watts */

component commLink {
  

}

component Earth {
  member of LinkBudget,desc; /* ?? Syntax */

  g = 9.81;

  Component Atmosphere { CommAmplitude = 0.3; }
  Component Ionosphere { CommAmplitude = 0.1; }
  Component Rain { CommAmplitude = distribution(max=1, min=0, avg=0.2); }
  
}

component Moon {
  RefFrame = Earth;
  RefTime = AD; 
  RevPeriod = 28.45 * 24 * 3600; /* in seconds */
  Pose(t) (6) = {EarthDist*cos(t/RevPeriod), EarthDist*sin(t/RevPeriod),
		  0,0,0,0};
  EarthDist = 384.0E6; /* meters */
  g = 9.81/6;
}

component Space {

  memberof LinkBudget;
  source C = nil; /* component typically base station - eg Earth */
  dest C = nil;
  CommAmplitude (
}

component Antenna {

  legaltype = {parabolic, omni, annular};
  frequency = nil;
  type = nil;
  
}
