/*******************************************************************************
+
+  LEDA 3.5
+
+  _color.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

#include <LEDA/color.h>
#include <LEDA/impl/x_basic.h>

#include <stdio.h>

color::color() : ok(true)
{ col_index = 0; }

color::color(const char* name) 
{ col_index = x_new_color(name);  
  if (col_index == -1) col_index = white;
}

color::color(int i ) : ok(true) { col_index = i;  }

color::color(int r, int g, int b) 
{ col_index = x_new_color(r,g,b); 
  ok = true;
  if (col_index == -1) 
  { col_index = white;
    ok = false;
   }
}


void color::get_rgb(int& r,int& g,int& b)
{ x_get_palette(col_index,&r,&g,&b); }


void color::set_rgb(int r, int g, int b)
{ x_set_palette(col_index,r,g,b); }


void color::set_red(int x)
{ int r,g,b;
  x_get_palette(col_index,&r,&g,&b); 
  x_set_palette(col_index,x,g,b);
}

void color::set_green(int x)
{ int r,g,b;
  x_get_palette(col_index,&r,&g,&b); 
  x_set_palette(col_index,r,x,b);
}

void color::set_blue(int x)
{ int r,g,b;
  x_get_palette(col_index,&r,&g,&b); 
  x_set_palette(col_index,r,g,x);
}

