/*******************************************************************************
+
+  LEDA 3.5
+
+  _slist.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/impl/slist.h>

//------------------------------------------------------------------------------
// Members of class SLIST
//
// S. N"aher (1993)
//------------------------------------------------------------------------------

SLIST::SLIST()      
{ h=0; 
  t=0;
  count=0;
  iterator=0; 
}

SLIST::SLIST(GenPtr a) 
{ h=t=new slink(a,0);
  count=1; 
  iterator=0;  
}


SLIST::SLIST(const SLIST& x)
{ register slink* p;

  iterator=h=t=0; 
  count = 0; 
                              
  for (p = x.h; p; p = p->succ) append(p->e); 

  int type_id = el_type_id();
  if (type_id != INT_TYPE_ID && type_id != PTR_TYPE_ID)
    for (p = h; p; p = p->succ) x.copy_el(p->e);
}

GenPtr SLIST::pop()    
{ if (h == 0) 
      error_handler(1,"slist: pop on empty list.");
  slink* x = h; 
  GenPtr e = x->e;
  h = h->succ; 
  if (h == 0) t = 0;
  count--;
  delete x;
  return e;
}

/*
void SLIST::del_succ(slink* p)    
{ slink* q = p->succ;
  if (q) 
  { if (t==q) t = p;
    p->succ = q->succ; 
    delete q;
    count--;
   }
}
*/


slink* SLIST::insert(GenPtr a, slink* p)   
{ count++;
  p->succ = new slink(a,p->succ); 
  if (t==p) t = p->succ;
  return h;
}

void SLIST::conc(SLIST& l)
{ 
  if (count > 0) 
   { t->succ = l.h;
     if (l.count > 0) t = l.t; 
    }
 else 
   { h = l.h; 
     t = l.t; 
    }
 count = count+l.count;
 l.h = l.t = 0;
 l.count = 0;
}


slink* SLIST::cyclic_succ(slink* loc) const
{ if (loc==0) return 0;
  return loc->succ? loc->succ : h;
 }

SLIST& SLIST::operator=(const SLIST& x)
{ register slink* p;

  clear();

  for (p = x.h; p; p = p->succ) append(p->e); 

  int type_id = el_type_id();
  if (type_id != INT_TYPE_ID && type_id != PTR_TYPE_ID)
    for (p = h; p; p = p->succ) copy_el(p->e);

  return *this;
 }

void SLIST::clear()
{ if (h==0) return;

  register slink* p;

  int type_id = el_type_id();
  if (type_id != INT_TYPE_ID && type_id != PTR_TYPE_ID)
    for (p = h; p; p = p->succ) clear_el(p->e);

  std_memory.deallocate_list(h,t,sizeof(slink));
  iterator=h=t=0;
  count=0;
 }
