/*******************************************************************************
+
+  LEDA 3.5
+
+  regtest.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_REGTEST_H
#define LEDA_REGTEST_H

#include <LEDA/stream.h>

#define LEDA_TEST_START(testid,testtask) \
file_ostream F_log(#testid".log"); \
file_ostream F_err(#testid".err"); \
bool leda_test_success=true;       \
F_log << "Name: "#testid" test\n"; \
F_log << "Task: "#testtask"\n"; \
F_err << "Name: "#testid" test\n"; \
F_err << "Task: "#testtask"\n"; 


#define LEDA_TEST(cond,fstr)   \
if (cond) {        \
  F_log << #fstr" ok\n"; F_log.flush();  \
}else{ \
  leda_test_success = false; \
  F_log << #fstr" error\n"; F_log.flush();  \
  F_err << "Error in "#fstr":\n  Test failed: "#cond; \
  F_err << "\nin file " << __FILE__ << " at line " << __LINE__ << "\n"; \
  F_err.flush();\
}


#define LEDA_TEST_END(fstr) \
if (leda_test_success) { \
  F_log << #fstr"-test finished successfully!\n"; \
  F_err << #fstr"-test finished successfully!\n"; \
} else { \
  F_log << #fstr"-test finished with errors!\n"; \
  F_err << #fstr"-test finished with errors!\n"; \
} F_log.close(); F_err.close();


#define TRACE(t) cout << t
#define TRACEN(t) cout << t << "\n"

#endif 


