/*******************************************************************************
+
+  LEDA 3.5
+
+  rs_tree.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_RS_TREE_H
#define LEDA_RS_TREE_H

//------------------------------------------------------------------------------
//
// rs_tree:  
//
//           randomized search trees (derived from class "bin_tree")
//
// Stefan N"aher (1993)
//
//------------------------------------------------------------------------------


#include <LEDA/basic.h>
#include <LEDA/impl/bin_tree.h>

 
typedef bin_tree_node* rs_tree_item;

 
//-----------------------------------------------------------------
// class rs_tree
//-----------------------------------------------------------------

class rs_tree : public bin_tree
{ 
  int root_balance() { return rand_int.get(); }
  int node_balance() { return rand_int.get(); }
  int leaf_balance() { return 0; }

  void insert_rebal(rs_tree_item);
  void del_rebal(rs_tree_item, rs_tree_item);


public:

 rs_tree() {}
~rs_tree() {}
 rs_tree(const rs_tree& T) : bin_tree(T) {}
 rs_tree& operator=(const rs_tree& T) { bin_tree::operator=(T); return *this; }

};

#endif


