#include <LEDA/d3_hull.h>


template <class POINT>
void d3_hull_test(const list<POINT>& L, GRAPH<POINT,int>& H, char* s, int k)
{ int n,m;
  float t;
  cout << string("%s:   ",s) << flush;
  t = used_time();
  D3_HULL(L,H,k);
  t = used_time() - t;
  n = H.number_of_nodes();
  m = H.number_of_edges();
  cout << string("|V| = %4d  |E| = %4d  time = %5.2f sec",n,m,t) << endl;
  CHECK_HULL(H);
}



main() {

 int N = read_int("n = "); 

 d3_rat_point p;
 list<d3_rat_point> L;
 list<d3_point> L1;

 GRAPH<d3_rat_point,int> H;
 GRAPH<d3_point,int> H1;

 random_points_in_cube(N,1000,L);
 L1.clear();
 forall(p,L) L1.append(p.to_d3_point());
 //d3_hull_test(L, H, "cube  ", 0);
 d3_hull_test(L, H, "cube   (exact)",-1);
 d3_hull_test(L1,H1,"cube   (float)",-1);
 newline;

 random_points_in_ball(N,1000,L);
 L1.clear();
 forall(p,L) L1.append(p.to_d3_point());
 //d3_hull_test(L, H, "ball  ", 0);
 d3_hull_test(L, H, "ball   (exact)",-1);
 d3_hull_test(L1,H1,"ball   (float)",-1);
 newline;

 points_on_sphere(N,1000,L);
 L1.clear();
 forall(p,L) L1.append(p.to_d3_point());
 d3_hull_test(L, H, "sphere (exact)",-1);
 d3_hull_test(L1,H1,"sphere (float)",-1);
 newline;

 return 0;
}
