\documentclass[12pt,a4paper]{article}

\input  MANUAL.pagesize

\input  MANUAL.mac

\begin{document}

\begin{manual}

\section*{Stacks (stack)}\label{stack}

\definition

An instance $S$ of the parameterized data type \mbox{$\mathit{stack}\<\mathit{E}\>$} is
a sequence of elements of data type $E$, called the element
type of $S$. Insertions or deletions of elements take place only at one end of
the sequence, called the top of $S$. The size of $S$ is the length of the
sequence, a stack of size zero is called the empty stack. 


\creation

\create {\mbox{$\mathit{stack}\<\mathit{E}\>$}}
{\mbox{$\mathit{S}$}} 
{$\,$} 
{creates an instance \mbox{$\mathit{S}$} of type \mbox{$\mathit{stack}\<\mathit{E}\>\nspacedot.$} \mbox{$\mathit{S}$} is 
            initialized with the empty stack. 
}

\setlength{\typewidth}{2cm}
\setlength{\callwidth}{4cm}
\computewidths
\operations

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{S}\nspacedot.$}top} 
{$\,$} 
{returns the top element of \mbox{$\mathit{S}$}.\\
             \precond $S$ is not empty. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{S}\nspacedot.$}push} 
{\mbox{$\mathit{E}\ \mathit{x}$}} 
{adds $x$ as new top element to \mbox{$\mathit{S}$}. 
}

\function {\mbox{$\mathit{E}$}}
{\mbox{$\mathit{S}\nspacedot.$}pop} 
{$\,$} 
{deletes and returns the top element of \mbox{$\mathit{S}$}.\\
             \precond $S$ is not empty. 
}

\function {\mbox{$\mathit{int}$}}
{\mbox{$\mathit{S}\nspacedot.$}size} 
{$\,$} 
{returns the size of \mbox{$\mathit{S}$}. 
}

\function {\mbox{$\mathit{bool}$}}
{\mbox{$\mathit{S}\nspacedot.$}empty} 
{$\,$} 
{returns true if \mbox{$\mathit{S}$} is empty, false otherwise. 
}

\function {\mbox{$\mathit{void}$}}
{\mbox{$\mathit{S}\nspacedot.$}clear} 
{$\,$} 
{makes \mbox{$\mathit{S}$} the empty stack. 
}

\implementation

Stacks are implemented by singly linked linear lists. All operations take 
time $O(1)$, except clear which takes time $O(n)$, where $n$ is the size of 
the stack. 


\end{manual}
\end{document}
