// vdynamics.cpp		implementation of VectorDynamics Class

static const char rscid[] = "@(#)vdynamics.c++	1.2 13:26:53 7/2/93   EFC";

#include <string.h>
#include <vdynamics.hpp>

VectorDynamics::VectorDynamics(int n_in, int m_in,float dxin, float dtin,
		char *nam) : n(n_in), m(m_in), dx(dxin), dt(dtin)
{
	u = new Vector[m];

	for (int k = 0; k < m; k++)
	 	u[k].resize(n);

	r = dt / dx;

	if ( nam != NULL )
	{
		namelen = strlen( nam ) + 1;
		name = new char[ namelen ];
		strcpy( name, nam );
	}
	else
		namelen = 0;

}

VectorDynamics& restart(VectorDynamics& s)
{
	 s.t = 0.0;

	 for (int i = 0; i < s.m; i++)
	 	s.u[i] = 0.0;

	 return s;
}

Vector* operator<<(Vector* v,const VectorDynamics& model)
{
	for (int i = 0; i < model.m; i++)
		v[i] = model.u[i];

	return v;
}

VectorDynamics& operator<<(VectorDynamics& model,Vector* v)
{
	for (int i = 0; i < model.m; i++)
		model.u[i] = v[i];

	return model;
}

Vector* operator>>(const VectorDynamics& model, Vector* v)
{
	for (int i = 0; i < model.m; i++)
		v[i] = model.u[i];

	return v;
}

VectorDynamics& operator>>(Vector *v, VectorDynamics& model)
{
	for (int i = 0; i < model.m; i++)
		model.u[i] = v[i];

	return model;
}
	
ostream& operator<<(ostream& os, const VectorDynamics& model)
{
	for(int i = 0; i < model.m; i++)
		os << model.u[i] << '\n';

	return os;

}
