// standio.cpp		Implementation of Stdin and Stdout

static const char rcsid[] = "@(#)standio.c++	1.5 11:46:11 7/2/93   EFC";

#include "standio.hpp"

#ifdef LOCAL_FILEBUF
Stdin::Stdin(int *argc, char **argv) : ios(&InputFile), fname(NULL)
#else
Stdin::Stdin(int *argc, char **argv) :  fname(NULL)
#endif
{
        open_input(argc, argv);
}

#ifdef LOCAL_FILEBUF
Stdin::Stdin(char *infile) : ios(&InputFile), fname(NULL)
#else
Stdin::Stdin(char *infile) :  fname(NULL)
#endif
{
	if ( infile )
        	do_open_input(infile);
        else		// no file named, so attach to STANDARD IN
        {
#ifdef LOCAL_FILEBUF
		InputFile.attach( 0 );
#endif
#ifdef __GNUC__
		rdbuf()->attach(0);
#else
                attach(0);
#endif
	}

}

int Stdin::do_open_input(char* infile)
{
#ifdef LOCAL_FILEBUF
		if ( InputFile.open(infile, ios::in ) == (filebuf *)NULL)
#else
		open( infile, ios::in );
		if ( rdstate() )
#endif                
		{
			return -1; 	// an error occurred
		}

#ifdef LOCAL_FILEBUF
		attach( InputFile.fd() );
#endif
        	fname = infile;
                
		return 0;
}


// if argv[1] exists and does not start with '-',
// consider it an input file name
// reduce argc and shift *argv over after a successful open
void Stdin::open_input(int *argc, char **argv)
{

	if ( *argc >= 2 && *argv[1] != '-')
	{

		if ( do_open_input( argv[1] ) )
                		return;		// an error occurred

		// at this point shuffle all the args over one to the left
		for (int i = 0; i < *argc; i++)
			argv[i] = argv[i + 1];

		(*argc)--;
                
	}
        else		// no file named, so attach to STANDARD IN
        {
#ifdef LOCAL_FILEBUF
		InputFile.attach( 0 );
#endif
#ifdef __GNUC__
		rdbuf()->attach(0);
#else
                attach(0);
#endif

	}
                        
	return;			// normal return
}

#ifdef LOCAL_FILEBUF
Stdout::Stdout(int *argc, char **argv) : ios(&OutputFile), fname(NULL)
#else
Stdout::Stdout(int *argc, char **argv) : fname(NULL)
#endif
{
	open_output(argc, argv);
}

#ifdef LOCAL_FILEBUF
Stdout::Stdout(char* outfile) : ios(&OutputFile), fname(NULL)
#else
Stdout::Stdout(char* outfile) : fname(NULL)
#endif
{
	if ( outfile )
		do_open_output( outfile );
	else		// no file named, so attach to STANDARD OUT
        {
#ifdef LOCAL_FILEBUF
		OutputFile.attach(1);
#endif
#ifdef __GNUC__
		rdbuf()->attach(1);
#else
                attach(1);
#endif
	}
}

int Stdout::do_open_output(char* outfile)
{
#ifdef LOCAL_FILEBUF
		if ( OutputFile.open( outfile, ios::out) == (filebuf *)NULL)
#else
                open( outfile, ios::out );

		if ( rdstate() )
#endif
		{
			return -1;		// an error occurred
		}

#ifdef LOCAL_FILEBUF
		attach( OutputFile.fd() );
#endif
        	fname = outfile;
                

		return 0;
}

// if argv[1] exists and does not start with '-',
// consider it an output file name
// reduce argc and shift *argv over after a successful open
void Stdout::open_output(int *argc, char **argv)
{

	if ( *argc >= 2 && *argv[1] != '-')
	{
		if ( do_open_output( argv[1] ) )
			return;		// an error occurred

		// at this point shuffle all the args over one to the left
		for (int i = 0; i < *argc; i++)
			argv[i] = argv[i + 1];

		(*argc)--;
	}
	else		// no file named, so attach to STANDARD OUT
        {
#ifdef LOCAL_FILEBUF
		OutputFile.attach(1);
#endif
#ifdef __GNUC__
		rdbuf()->attach(1);
#else
                attach(1);
#endif

	}
        
	return;				// normal return
}


