// Matrix.hpp

// A matrix definition	 for real or complex matrices
//	a nonsquare generalization of class in Computers In Physics Jan/Feb 1990

// rcsid: $Id$ @(#)matrix.hpp	1.6 14:47:48 9/25/92  EFC

#ifndef _MATRIX_H
#define _MATRIX_H 1.6

#include <stdio.h>

#ifdef __ZTC__
#include <iostream.hpp>
#else
#include <iostream.h>
#endif

#include <math.h>

#ifndef INCLUDE_VECTOR
#define INCLUDE_VECTOR
#endif

#include <barray2d.hpp>

#ifdef INCLUDE_VECTOR
#include <vector.hpp>
#endif


#ifdef USE_MATRIX_ROW
class MatrixRow
{
	private:
	   int index;
	   scalar_type **m;
	public:
	  MatrixRow() {}
	  MatrixRow(const int i, scalar_type** mi) : index(i), m(mi) {}
	  MatrixRow(const MatrixRow& rw) : index(rw.index), m(rw.m)  {}
	 ~MatrixRow() {}
	  void assoc(const int i, scalar_type** mi) { index = i; m = mi; }
	  scalar_type& operator[](const int j)      { return m[index][j]; } 
};
#endif

class Matrix : public Basic2DArray
{
	protected:
#ifdef USE_MATRIX_ROW
		MatrixRow row;
#endif
	public:
		Matrix(const int r,const int c) : Basic2DArray(r,c) {}
		Matrix() {}
		Matrix(const Matrix& m) : Basic2DArray(m) {}	// initialization
		~Matrix() {}				// destructor

	Matrix&	operator=(const Matrix&);		// assignment

	// scalar assignment
	scalar_type operator=(const scalar_type v) { reset(v); return v; }

#ifdef USE_MATRIX_ROW
	MatrixRow    operator[](const int i) { row.assoc(i,m); return row; }
	MatrixRow    operator[](const int i) const { row.assoc(i,m); return row; }
#endif

	void diag(const scalar_type fv);			// set diagonals
	friend Matrix operator+(const Matrix&,const Matrix&);	// Mat+Mat
	friend Matrix operator-(const Matrix&,const Matrix&);	// Mat-Mat
	friend Matrix operator*(const Matrix&,const Matrix&);	// Mat*Mat
	friend Matrix operator*(const double&,const Matrix&);	// double*Mat
#ifdef COMPLEX
	friend Matrix operator*(const Complex&,const Matrix&);	// Complex*Mat
#endif
#ifdef INCLUDE_VECTOR
	friend Vector operator*(const Matrix&,Vector&);		// Mat*Vector
#endif
	friend int operator==(const Matrix&,const Matrix&);	// equality
	friend Matrix comm(const Matrix&,const Matrix&);	// commutator
	friend Matrix herm(const Matrix&);			// hermitean conj
	friend Matrix transpose(const Matrix&);			// transpose
	friend scalar_type trace(const Matrix& );		// trace

};


#endif
