// lumatrix.hpp

// A matrix definition for matrices in LU form
// includes automatic conversion to LUMatrix from Matrix,
// and a coersion the other way

// rcsid: @(#)lumatrix.hpp	1.5 00:58:45 7/2/93   EFC

// NOTE: os << LUMatrix with TURBO C++ V1.0, causes a conversion to Matrix
//		        then calls << Matrix
//		        With Zortech C++ V2.1 the same statement does not cause
//			a conversion, LUMatrix inherits << from Matrix
//
// From my understanding of C++, I think the Zortech behaviour is the right one


#ifndef LUMATRIX_H_
#define LUMATRIX_H_ 1.5

#include <matrix.hpp>

class LUMatrix : public Matrix {
	private:
		int *pivot;
		int errval;
	public:
		LUMatrix() : errval(0), pivot(NULL)    {}  // default constructor
		 // constructor
		LUMatrix(const int r,const int c) : Matrix(r,c), errval(0)
					 { pivot = new int[r]; }
		LUMatrix(const LUMatrix&);		// initialization
		LUMatrix(const Matrix& a) { *this = lufact(a); } // initialization from a Matrix
		~LUMatrix() { delete []pivot; }		// destructor
	LUMatrix& operator=(const LUMatrix&);		// assignment
	operator Matrix() const;			// cast TO Matrix
	friend LUMatrix lufact(const Matrix &a);	// explicit conversion
	friend double det(const LUMatrix &);
	friend double deti(const LUMatrix &, int *);
	friend void backsub(const LUMatrix &, double *);
	friend void backt(const LUMatrix &, double *);
	friend Matrix invm(const LUMatrix &);

};

#endif

