// LUMatrix.cpp		a LU matrix class implementation

static const char rcsid[] = "@(#)lumatrix.c++	1.5 00:58:58 7/2/93   EFC";

// #define DEBUG

#include <stdio.h>

#include <lumatrix.hpp>

LUMatrix::LUMatrix(const LUMatrix &a)	// LUMatrix m = a
{
	int i, j;
	int r = a.rows,	c = a.cols;

	resize(r,c);
	pivot = new int[r];
	
	for (i = 0; i < r; i++)
	{
		pivot[i] = a.pivot[i];
		for (j = 0; j < c; j++)
			m[i][j] = a.m[i][j];
	}
	
}


LUMatrix& LUMatrix::operator=(const LUMatrix &a)		// m = a
{
	int i, j, r = a.rows, c = a.cols;

	if ( this == &a )
		return *this;

	for (j = 0; j < r; j++)
		delete m[j];

	delete m;

	resize(r,c);
	pivot = new int[r];

	for (i = 0; i < r; i++)
	{
		pivot[i] = a.pivot[i];
		for (j = 0; j < c; j++)
			m[i][j] = a.m[i][j];
	}

	return *this;
}

/* lufact.c	lufact		*/

/* routines for linear systems processing via LU factorization
	from C Tools for Scientist and Engineers, L. Baker, 1989	*/

LUMatrix lufact(const Matrix &a)
{
	int i, j, k, l, kp1, nm1, n;
	int *piv;
	double t, q;

	n = a.rows;

	LUMatrix lu(n,n);

	//	lu = a;	 must do it by copying or LUFACT will be recursively called !
	for (i = 0; i < n; i++)
			for (j = 0; j < n; j++)
				lu[i][j] = a[i][j];

	lu.errval = 0;
	nm1 = n - 1;
	piv = lu.pivot;
	for (k = 0; k < n; k++)
			*(piv++) = k;

	if (nm1 >= 1)	/* non-trivial problem */
	{
		for (k = 0; k < nm1; k++)
		{
			kp1 = k + 1;
			/* partial pivoting ROW exchanges
				-- search over column */
			t = 0.0;
			l = k;
			for (i = kp1; i < n; i++)
			{
				q = fabs( a[i][k] );
				if ( q > t )
				{
					t = q;
					l = i;
				}
			}
			lu.pivot[k] = l;

			if ( lu.m[l][k] != 0.0 )
			{			/* nonsingular pivot found */
				if (l != k )	/* interchange needed */
					for (i = k; i < n; i++)
					{
						t = lu.m[l][i];
						lu.m[l][i] = lu.m[k][i];
						lu.m[k][i] = t;
					}
				q = 1.0 / lu.m[k][k];	/* scale row */
				for (i = kp1; i < n; i++)
				{
					t = - q * lu.m[i][k];
					lu.m[i][k] = t;
					for (j = kp1; j < n; j++)
						lu.m[i][j] += t * lu.m[k][j];
				}
			}
			else		/* pivot singular */
				lu.errval = k;
		}

	}

	lu.pivot[ nm1 ] = nm1;
	if (lu.m[nm1][nm1] == 0.0)
		lu.errval = nm1;

	return lu;

}


// a type cast from an LUMatrix directly to a Matrix
LUMatrix::operator Matrix() const		// Matrix m = LUMatrix a
{
	int i, j, r = rows, c = cols;


	Matrix mat( r, c );
	
	for (i = 0; i < r; i++)
		for (j = 0; j < c; j++)
			mat[i][j] = m[i][j];

	return mat;
	
}











