// error.cpp		start of Implementation of general error reporting class

static const char rcsid[] = "%W% %U% %G%   EFC";

#include <string.h>
#include <error.hpp>

// a nonmember function, mostly so I remember how to do a manipulator
ostream& terminate(ostream& os)
{
	os.flush();
	exit(1);

	return os;		// keeps the compiler happy
}

Error::Error(const char *title, ostream& user_os) :
#ifdef LOCAL_STRBUF
	 ios(&buffr),
#endif
	 my_os(user_os)
{
	len = strlen( title ) + 1;

	prog = new char[len];
	strcpy(prog, title);
}

void Error::report(const char *msg)
{
	if ( msg == NULL )		// message must have been sent via <<
	{
		*this << ends;		// just to be safe
#ifdef LOCAL_STRBUF
		my_os << buffr.str();
		buffr.freeze(0);
#else
		my_os  << str();
		rdbuf()->freeze(0);
#endif
		seekp(0);		// rewind to beginning
	}
	else
		my_os << msg;

	my_os << '\n';


}

void Error::warning(const char *msg)
{
	my_os << prog << " Warning: ";

	report( msg );

}

void Error::fatal(const char *msg)
{
	my_os << prog << " Fatal error: ";

	report( msg );
	my_os.flush();
	exit(1);
}

void Error::memory(const void *p)
{
	if ( p == (void *)NULL )
	{
		my_os << prog << " Memory allocation error" << endl;
		exit(1);
	}

}
