#include "XppXYPlot.h"
#include <math.h>



// This code draws a butterfly curve.
// From "Computers and the Imagination" by Clifford A. Pickover, pg 21


int main()
{
  XppXYPlot  p(500,500, -1);     // Create an xyplot window
  
  p.SetDrawingCoordinates(-50,50,-50,50); // Set the coordinate system
  p.SetAutoRedrawOnExpose();              
 
  double pi = 3.1415;
  double r, d, x, y;
  
  // Draw the butterfly curve
  for( double theta = 0.0; theta <= 100*pi; theta += 0.01)
    {
      r = exp( cos(theta) ) - 2*cos(4*theta) + (d = sin(theta/12))*d*d*d*d;
      x = r*cos(theta);
      y = r*sin(theta);
      p.Plot(x*6, y*6);   // Plot the data point
    }
  p.Flush();
   
  p.Pause();        // Wait 
}

  
  
