//=========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//=========================================================================

#ifndef __XppWindowH__
#define __XppWindowH__

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "XppManager.h"

//========================================================================
// The XppWindow class defines an abstract data type  that allows  you
// to create an X window. It defines window graphics drawing functions and
// allows you to interact with the window using the keyboard or mouse.
//========================================================================

class XppWindow  : private XppClient
{
  public:
    // Constructors
    XppWindow(int width, int height, int x=0, int y=0, char *name = "window");
    XppWindow(XppWindow& win, int w, int h, int x=0, int y=0, int borderWidth=1);
    virtual ~XppWindow(void);

    // Window graphics drawing functions
    void DrawPoint(int x, int y);
    void DrawLine(int x1, int y1, int x2, int y2);
    void DrawRectangle(int x, int y, int width, int height);
    void DrawFilledRectangle(int x, int y, int width, int height);
    void DrawSquare(int x, int y, int r);       
    void DrawFilledSquare(int x, int y, int r); 
    void DrawArc(int x, int y, int r, int theta1, int theta2);  
    void DrawFilledArc(int x, int y, int r, int theta1, int theta2); 
    void DrawCircle(int x, int y, int r);
    void DrawFilledCircle(int x, int y, int r);
    void DrawText(int x, int y, char *text);

    void SetAutoRedrawOnExpose(void);         
    void Clear(void);
    void SetDrawColor(char *colorName);
    void SetDrawBlack(void);
    void SetDrawWhite(void);
    void Flush(void);

    // Window user interaction 
    void Pause(void);    
    void GetCommand(char&  command);   
    int  ScanCommand(char& command); 
    int  ScanMouse(int& x, int& y);       
    void SelectWindowEvents(long eventMask);
    int  Exposed(void);

  protected:
    Display *fDisplay;     // The X Window appears on this display 
    int      fScreen;      // The X Window appears on this screen 
    Colormap fCmap;        // The X Window uses this color map 
    Window   fWindow;      // X window resource id
    GC       fGC;          // Graphics Context resource id
    long     fEventMask;   // Events solicited for this window
    Drawable fDrawable;    // Draw everything on this 
    Pixmap   fPixmap;      // Pixmap to draw on for auto-redraw window feature
    int      fAutoRedrawOnExpose;      // True - if auto-redraw feature is on 

    int fWidth, fHeight;   // Dimension of the X window
    unsigned long fWhite;  // Black pixel value
    unsigned long fBlack;  // White pixel value
    unsigned long FindColor(char *name);

    virtual void ProcessEvents();                 
    virtual void HandleXEvent(XEvent& event);  // Handle this window event

  private:
    // Base class disables copy constructor and assignment operator
    void Open(Window win, int w,int h, int x,int y, char *name, int brdrWidth);
    void Close();
    void HandleExposeIfAutoRedraw(XEvent& event);
};

#endif






