//============================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
//============================================================================

#ifndef __XppManager__
#define __XppManager__

#include <X11/Xlib.h>       
#include <X11/Xutil.h>

class XppClient;

//============================================================================
// The global object gXManager is an instance of class XppManager that
// opens up the display and screen for X applications.
// A single global manager gXManager exists for each application
// The  gXManager keeps a list of clients (object of class XppClient)
// that need service for window events. 
//============================================================================

class XppManager
{
  public:
    XppManager(void);
   ~XppManager(void);
  
    // Management of X Clients (windows)
    void CheckIn(XppClient&);    
    void CheckOut(XppClient&);   

    void Run(void);      // Execute event handling loop
    void Scan(void);     // Execute one pass through event handling loop

    // Access to X resources
    Display* AppDisplay(void)   {  return(fDisplay);  }          
    int      AppScreen(void)    {  return(fScreen);   }
    Colormap AppCmap(void)      {  return(fCmap);     }
    Font     AppFont(int i);      // Return the ith font

  private:
    Display *fDisplay;         // The workstation (display) 
    int      fScreen;          // The screen that this Xapplication uses
    Colormap fCmap;            // Color map for this Xapplication.
    Font     *fFont;           // Array of fonts in this application

    XppClient* fClientList;  // List of Objects

    // Disable the default copy constructor and assignment operator
    XppManager(const XppManager&);  
    XppManager& operator = (const XppManager&);  
};

// A global application manager exists for each program
extern XppManager gXManager;   


// ============================================================================
// XppClients are objects that need to be serviced periodically.
// Typically an XppClient would be an X Window that needs to process window 
// events.
// The gXManager maintains a list of XppClient objects and
// asks them to ProcessEvents() in turn.
// ============================================================================

class XppClient
{
  friend class XppManager;
  public:
    XppClient(void);
    virtual ~XppClient(void);

    virtual void ProcessEvents(void) = 0;  

  private:
    XppClient* fNext;

    // Disable the default copy constructor and assignment operator 
    XppClient(const XppClient&);  
    XppClient& operator = (const XppClient&); 
};


#endif




