//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================

#include <iostream.h>
#include <stdlib.h>
#include "XppManager.h"
#include "XppFonts.h"

// Open a global manager for this application 
XppManager  gXManager;      

//============================================================================
XppManager::XppManager(void)
{
  fDisplay = 0;
  fFont   = new Font[gcNumberOfFonts];          // Create space for fonts
  for(int i = 0; i < gcNumberOfFonts; i++) 
    fFont[i] = None;                            // No fonts loaded yet
  
  fClientList = 0;                              // The client list is empty
}

//============================================================================
XppManager::~XppManager(void)
{
  //... Free any fonts loaded
  if( fDisplay ) XCloseDisplay(fDisplay);       // Close the display
}

//============================================================================
void XppManager::CheckIn(XppClient& client)
{
  if (!fDisplay)  // If the display hasn't been opened yet, open it.
    {   
      fDisplay = XOpenDisplay("");                  // Open the default display
      if (!fDisplay) 
        {cout << "XppManager -> Unable to open display"; exit(1);}
      fScreen = DefaultScreen(fDisplay);       // Default screen on the display
      fCmap   = DefaultColormap(fDisplay, fScreen); // Resource id of 
                                                    // default colormap
    }
  
  // Add the specified XppClient <client> to the client list
  
  XppClient* p;		// Pointer to traverse the list
  
  if(fClientList == 0) 
    fClientList = &client;	// Attach the client to the list
  else
    { 
      // The list is not empty 
      for(p = fClientList; p->fNext != 0; p = p->fNext)
	;			// Go to end of list
      p->fNext = &client;	// Attach the client to the end of the list
    }
}

//============================================================================
void XppManager::CheckOut(XppClient& client)
{
  // Remove the specified XppClient <client> from the client list
  
  XppClient* p;		// Pointer to traverse the list
  
  if(fClientList == &client) 
    fClientList = client.fNext;	// Client is at the head of the list. 
                                // Detach client.
  else
    {
      for(p=fClientList; ((p->fNext!= &client)&&(p->fNext!= 0)); p = p->fNext)
	;			// Search for the client in the list
      if(p->fNext == 0)
	{cout << "XppManager::CheckOut -> no client in list"; exit(1);}
      p->fNext = client.fNext;	// Detach client from list
    }
}

//============================================================================
void XppManager::Scan(void)
{
  XppClient* p;
  
  XFlush(fDisplay);
  for(p = fClientList; p != 0; p = p->fNext) // For every client in the list
    { 
      p->ProcessEvents();	// Ask the client to process its events
    }
}

//============================================================================
void XppManager::Run(void)
{
  // This is the main processing loop
  
  while(1)
    {
      Scan();			// Service each client in the client list
    }
}


Font XppManager::AppFont(int i) 
{
  if((i < 0) || (i >= gcNumberOfFonts)) 
    { cout << "XppManager::Font ->No such font specified"; exit(1); }
  
  if(fFont[i] == None) 
    { fFont[i] = XLoadFont(fDisplay, gcFontName[i] ); }
  return (fFont[i]);
}




//===========================================================================
XppClient::XppClient(void) : fNext(0)
{
  gXManager.CheckIn(*this);	// register the client with the gXManager
}

//===========================================================================

XppClient::~XppClient(void)  
{
  gXManager.CheckOut(*this); // leave the service of the  gXManager
}








