//===========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//===========================================================================


#include "XppHistogram.h"

//===========================================================================
XppHistogram::XppHistogram(int w, int h, int x, int y, char *name)
  : XppBarGraph(w, h, x, y, name)
{ 
  // Open a bargraph on the root window to plot a histogram 
}

//===========================================================================
XppHistogram::XppHistogram(XppWindow& win, int w, int h, int x, int y)
  : XppBarGraph(win, w, h, x, y)
{ 
  // Open a bargraph within the specified XppWindow <win> to plot a histogram 
}
 







//===========================================================================
void XppHistogram::PlotHistogram(double *x, int dim, int numberOfBins)
{
  // Plot a histogram of the <dim> points x[i] with <numberOfBins> bins

  // Compute the range of the data points
     double min =  1e30;
     double max = -1e30;
  
     for(int i=0; i<dim; i++)
       {
	 if(x[i] < min) min = x[i];
	 if(x[i] > max) max = x[i];
       }

  // Plot the histogram with the computed range
     PlotHistogram(x, dim, min, max, numberOfBins);
}

//===========================================================================
void XppHistogram::PlotHistogram(double *x, int dim, double min, double max, 
                                                             int numberOfBins)
{
  // Plot a histogram of the <dim> points x[i] within the range [<min>,<max>] 
  // The range is divided into <numberOfBins> bins. The percentage of points
  // within each interval is plotted as a bar in the histogram.

  // Check the parameters 
  if( (numberOfBins <= 0) || (max <= min) )
    {
      XppWindow::DrawText(0,10,"Incorrect parameters. Ignoring plot");
      return;
    }
  
  double binSize = (max - min)/numberOfBins;  // Calculate size of each bin

  double bin[numberOfBins];                                 // Create bins
  for(int i = 0; i < numberOfBins; i++)    bin[i] = 0.0;   // Reset bin count

  // Calculate number of points in each bin
     int binx;         // temp bin index
     int nrPoints = 0; // Track number of points within range included in histogram

     for(int k = 0; k < dim; k++)                // For every point x[k]
       {
	 if ( (x[k] >= min)&&(x[k] < max) )     // If x[k] is within the range
	   { 	 
	     binx = int( (x[k] - min)/binSize ); // find which bin x[k] is in
	     bin[binx] += 1.0;	          // increment the bin that x[k] is in
	     nrPoints++;                // One more point included in histogram
	   }
       }

  if(nrPoints > 0)
    {
      // Compute percentage of points in each bin 
      for(i = 0; i < numberOfBins; i++)
	{ 
	  bin[i] = 100*(bin[i]/nrPoints);
	}
    }

  // Specify cartesian coordinate system
  XppCanvas::SetDrawingCoordinates(0.0, (double) numberOfBins, 0.0, 100.0);

  // Draw bar graph
  XppBarGraph::SetAutoScalingOff();   // Override any attempt to do autoscaling
  XppBarGraph::PlotBarGraph(bin, numberOfBins);
}






