//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================

#ifndef __XppBarGraphH__
#define __XppBarGraphH__

#include "XppCanvas.h"

//============================================================================
// XppBarGraph is a canvas specialized for drawing BarGraphs.
//============================================================================

class XppBarGraph : public XppCanvas
{
  public:
    XppBarGraph(int width, int height,int x=0, int y=0, char *name="bargraph");
    XppBarGraph(XppWindow& win, int width, int height, int x = 0, int y = 0);

    // Plotting functions
    void SetStyleOutline(void);
    void SetStyleFilled(void);
    void SetAutoScalingOn(void);
    void SetAutoScalingOff(void);
    
    // Plot a bar of height y between x1 & x2
    void PlotBar(double x1, double x2, double y); 
    // PlotBar (i, i+1, y[i])     0<=i<n 
    void PlotBarGraph(double *y, int n);          
    // PlotBar (x[i],x[i+1],y[i]) 0<=i<n 
    void PlotBarGraph(double *x, double *y, int n); 

  private:
    enum APlotStyle { filled, outline};   // Define a couple of plotting styles
    APlotStyle fStyle;                    // Style selected for the plot

    int fAutoScaling;
};

#endif
  
