//==========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//==========================================================================


#ifndef __XppXYPlotH__
#define __XppXYPlotH__

#include "XppCanvas.h"

//==========================================================================
// A XppXYPlot is a XppCanvas  specialized for drawing x-y plots
//==========================================================================


class XppXYPlot : public XppCanvas
{
  public:
    XppXYPlot(int width, int height, int x=0, int y=0, char *name = "xyplot");
    XppXYPlot(XppWindow& win, int width, int height, int x = 0, int y = 0);    

    // Plotting functions
    void SetStyleDots(void);
    void SetStyleLines(void);

    void Plot(double x, double y);       // Plot point  (x, y)
    void Plot(double *y, int n);         // Plot points (i, y[i]), 0 <= i < n
    void Plot(double *x, double *y, int n); 
                                      // Plot points (x[i], y[i]), 0 <= i < n
    void Reset(void);                 // Reset plot to plot a new curve

  protected:
    void HandleXEvent(XEvent& event); // Handle X Events for this window

  private:
    enum APlotStyle { dots, lines};   // Define a couple of plotting styles
    APlotStyle fStyle;                // Style selected for the plot

    int fFirstLinePlot;   // Flag used while plotting first point in style lines
    double fLastX,fLastY; // Last point plotted on window 
};


#endif
