//==========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//==========================================================================

#include "iostream.h"
#include "XppXYPlot.h"


//============================================================================
XppXYPlot::XppXYPlot(int width, int height, int x, int y, char *name)
  : XppCanvas(width, height, x, y, name)
{ 
  // Open a Canvas on the root window with specified dimensions for plotting

  SetStyleLines();  // Lines is the default plotting style
}

//============================================================================
XppXYPlot::XppXYPlot(XppWindow& win, int width, int height, int x, int y)
  : XppCanvas(win, width, height, x, y)
{
  // Open an XppCanvas in the specified XppWindow <win> for plotting

  SetStyleLines(); // Lines is the default plotting style
}

//============================================================================
void XppXYPlot::SetStyleDots(void) {  fStyle = dots;  }
void XppXYPlot::SetStyleLines(void){  fStyle = lines; fFirstLinePlot = 1;}

//============================================================================
void XppXYPlot::Plot(double x, double y)
{
  // Plot a point in the x-y plot window

  switch(fStyle)
    {
    case lines:
      if(fFirstLinePlot)
	{                             
	  fLastX = x;  fLastY = y;    
	  fFirstLinePlot = 0;
	}
      XppCanvas::DrawLine(fLastX, fLastY, x, y);
      fLastX = x;  fLastY = y;
      break;

    case dots:
      XppCanvas::DrawPoint(x, y);
      break;
    }
}

//============================================================================
void XppXYPlot::Plot(double *y, int n)
{
  // Plot the <n> points <y[]> 

  for(int i=0; i<n; i++)    
    Plot( (double)i, y[i]);
}

//============================================================================
void XppXYPlot::Plot(double *x, double *y, int n)
{
  // Plot the <n> points <y[]> against <x[]> 

  for(int i=0; i<n; i++)    
    Plot(x[i], y[i]);
}



void XppXYPlot::Reset(void)
{
  fFirstLinePlot = 1;
}


void XppXYPlot::HandleXEvent(XEvent& event)
{ 
  // If the mouse is pressed in this window simply print the coordinates
  // of the mouse in the plotting coordinate system.
  if(event.type == ButtonPress)
    {
      double px = event.xbutton.x;
      double py = event.xbutton.y;

      cout << "(" << XW(px) << ", " << YW(py) << ")" << endl;
    }
}









