//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================

#ifndef __XppCanvasH__
#define __XppCanvasH__

#include "XppWindow.h"

//============================================================================
// A XppCanvas specializes a TWindow to allow an arbitrary coordinate system.
// All drawing operations are performed with respect to this coordinate system
//============================================================================

class XppCanvas   : public XppWindow
{
  public:
    XppCanvas(int width, int height, int x=0, int y=0, char *name = "canvas");
    XppCanvas(XppWindow& win, int width, int height, int x=0, int y=0);

    // Canvas graphics drawing functions
    void SetDrawingCoordinates(double left,double right,double down,double up);
    void DrawPoint(double x, double y);
    void DrawLine(double x1, double y1, double x2, double y2);
    void DrawRectangle(double x, double y, double width, double height);
    void DrawFilledRectangle(double x, double y, double width, double height);
    void DrawRectangleToFit(double x1, double y1, double x2, double y2);
    void DrawFilledRectangleToFit(double x1, double y1, double x2, double y2);
    void DrawSquare(double x, double y, double r);       
    void DrawFilledSquare(double x, double y, double r); 
    void DrawArc(double x, double y, double r, double theta1, double theta2);  
    void DrawFilledArc(double x,double y,double r,double theta1,double theta2);
    void DrawCircle(double x, double y, double r);
    void DrawFilledCircle(double x, double y, double r);
    void DrawText(double x, double y, char *text);
    void DrawXAxis(double atY);
    void DrawYAxis(double atX);
    void DrawXYAxes(double atX, double atY);

    int ScanMouse(double& x, double& y);
   

  protected:
    double XW(double x);  // Convert window x coordinate to canvas x coordinate
    double YW(double y);  // Convert window y coordinate to canvas y coordinate


  private:
    // Cartesion coordinate system defined in the canvas
    double fLeft;           // Horizontal axis leftmost value   
    double fRight;          // Horizontal axis rightmost value  
    double fUp;             // Vertical axis   topmost value
    double fDown;           // Vertical axis   bottommost value

    double fHScale;         // Horizontal plot scale factor 
    double fVScale;         // Vertical plot scale factor

    void SetScaling(void); // Computes the drawing scaling factors

    int  WX(double x);    // Convert canvas x-coordinate to window x-coordinate
    int  WY(double y);    // Convert canvas y-coordinate to window y-coordinate
    int  WLX(double lx);  // Convert canvas x-length from to window x-length
    int  WLY(double ly);  // Convert canvas y-length from to window y-length
};

#endif


