//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================


#include "XppBarGraph.h"


//===========================================================================
XppBarGraph::XppBarGraph(int width, int height, int x, int y, char *name)
  : XppCanvas(width, height, x, y, name)
{ 
  // Open an X window on the root window with specified dimensions for plotting

  SetStyleFilled();       // Bars are drawn filled by default
  SetAutoScalingOff();    // Turn off autoscaling 
}
 
//===========================================================================
XppBarGraph::XppBarGraph(XppWindow& win, int width, int height, int x, int y)
  : XppCanvas(win, width, height, x, y)
{
  // Open a  subwindow in the specified XppWindow <win> for plotting

  SetStyleFilled();      // Bars are drawn filled by default
  SetAutoScalingOff();   // Turn off autoscaling
}

//===========================================================================
void XppBarGraph::SetStyleFilled(void)    {  fStyle = filled;  }
void XppBarGraph::SetStyleOutline(void)   {  fStyle = outline; }
void XppBarGraph::SetAutoScalingOn(void)  {  fAutoScaling = 1; }
void XppBarGraph::SetAutoScalingOff(void) {  fAutoScaling = 0; }
    
//===========================================================================
void XppBarGraph::PlotBar(double x1, double x2, double y)
{
  // Plot bar of height y between x1 and x2

  switch(fStyle)
    {
    case filled:
      XppCanvas::DrawFilledRectangleToFit(x1, 0, x2, y);
      break;
    case outline:
      XppCanvas::DrawRectangleToFit(x1, 0, x2, y);
      break;
    }
}

//===========================================================================
void XppBarGraph::PlotBarGraph(double *y, int n)
{
  // Plot bars of height y[i] between i and i+1   0 <= i < n

  if(fAutoScaling) 
    {
      // Compute y range
      double ymin = 1e30;  double ymax = -1e30;
      for(int i=0; i<n; i++)
	{
	  if(y[i] < ymin) ymin = y[i];
	  if(y[i] > ymax) ymax = y[i];
	}

      XppCanvas::SetDrawingCoordinates(0.0, (double)n, ymin, ymax);
    }
	  
  for( int i=0; i<n; i++)   PlotBar( (double)i, (double)(i+1), y[i] ); 
}

//==========================================================================
void XppBarGraph::PlotBarGraph(double *x, double *y, int n)
{
  // Plot bars of height y[i] between x[i] and x[i+1]   0 <= i < n

  if(fAutoScaling) 
    {
      // Compute x and y range
      double xmin = 1e30;   double xmax = -1e30;
      double ymin = 1e30;   double ymax = -1e30;
      for(int i=0; i<n; i++)
	{
	  if(x[i] < xmin) xmin = x[i];
	  if(x[i] > xmax) xmax = x[i];
	  if(y[i] < ymin) ymin = y[i];
	  if(y[i] > ymax) ymax = y[i];
	}

      XppCanvas::SetDrawingCoordinates(xmin, xmax, ymin, ymax);
    }

  for( int i=0; i<n; i++)    PlotBar( x[i], x[i+1], y[i] ); 
}











