// =========================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
// =========================================================================

#include "stdio.h"
#include "VwPopulation.h"

// =========================================================================
VwPopulation::VwPopulation(void)
: XppHistogram(400,100,-1,-1, "Population Histogram"),
  fP(0)
{ }

// =========================================================================  
void VwPopulation::View(EvPopulation< EvIndividual<EvRealGenome> >& p ) 
{  fP = &p;  }

// =========================================================================
void VwPopulation::Update(void)
{
  if(fP)
    {
      EvPopulation< EvIndividual<EvRealGenome> >& p = *fP; // I prefer references
      
      int size = p.Size();	// The population size
      double x[size];		// Array to hold performance values
      
      double pmax = -1e30; double pav = 0.0;
      for(int i=0;i<size;i++)
	{
	  x[i] = p[i].Performance(); // Scan in the performance values
          pav += x[i];
          if(x[i] > pmax)  pmax = x[i];
	}
      pav /= size;

      Clear();	// Clear the previous histogram and draw with 100 bins.
      PlotHistogram(x, size, 0.0, (pmax+0.1*pmax), 100); 

      char text[120];
      sprintf(text, "pmax =%8.4f  paverage =%8.4f", pmax, pav );
      XppWindow::DrawText(10,10, text);
      Flush();
    }
}




