// ============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
// ============================================================================
#ifndef __VwPendulumH__
#define __VwPendulumH__

#include "SysPendulum.h"
#include "XppCanvas.h"

// VwPendulum is a class to view SysPendulums 


class VwPendulum : public XppCanvas
{
  public:
    VwPendulum(void);
    void View(SysPendulum&);   // Set the pendulum to view
    
    void UpdateRate(int);    // How often is the view update
    void Update(void);       // update the view

  private:
    SysPendulum* fP;          // The pendulum to view
    int  fUpdateRate;
    int  fUpdateCount;
};

#endif



