// ============================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
// ============================================================================


#include <stdio.h>
#include "VwPendulum.h"


// ============================================================================
VwPendulum::VwPendulum( void )
 :XppCanvas(600,300,-1,-1,"Pendulum"), fP(0)
{
  XppCanvas::SetDrawingCoordinates(-4.0, 4.0, -2.0, 2.0);
  XppCanvas::SetAutoRedrawOnExpose();
  fUpdateRate   = 1;
  fUpdateCount  = 1;
}


// ============================================================================
void VwPendulum::View( SysPendulum& p) {  fP = &p; }


// ============================================================================
void VwPendulum::UpdateRate(int n)
{
  fUpdateRate  = n;   // Refresh the window every n updates
  fUpdateCount = n;   // Count down to next refresh 
}


// ============================================================================
void VwPendulum::Update(void)
{ 
  if(fP)
  {
    if(--fUpdateCount == 0)
      {
	fUpdateCount = fUpdateRate; // Reset the count

	XppCanvas::Clear();    // Erase everything
	
	// Draw the cart (width 0.5, height 0.5)
	DrawRectangle( -0.25, 0.125, 0.5, 0.25 );
	
	// Draw the pole (length 1.0)
	double px = sin( fP->fTheta );
	double py = cos( fP->fTheta );
	DrawLine( 0.0, 0.0, px, py );
	
	// Draw the pendulum bob
	DrawFilledCircle( px, py, 0.1 );  
	
	// Show the force on the cart
	DrawLine( 0.0, 0.0, 0.1*fP->fForce, 0.0 );
	
	// Draw ticks to simulate motion
	double center = fP->fH; // Where the cart is
	for(double x = -10.0; x < 10.0; x += 0.5 )
	  DrawLine( x - center, 0.0, x - center, 0.1 );
        DrawLine( -center, -1.0, -center, 1.0 );
	
	// Show data values  
	char text1[120], text2[120]; 
	sprintf(text1,"x =%8.4f   v =%8.4f     a =%8.4f :    force =%8.4f",
		fP->fH, fP->fHDot, fP->fHDDot, fP->fForce );
	sprintf(text2,"t =%8.4f  td =%8.4f   tdd =%8.4f :  cos(th) =%8.4f", 
		fP->fTheta, fP->fThetaDot, fP->fThetaDDot, cos(fP->fTheta));
	DrawText( -3.5, 1.7, text1 );
	DrawText( -3.5, 1.4, text2 );
      }
  }
}













