// ============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
// ============================================================================

#include "VwPDensity.h"


// ============================================================================
VwPDensity::VwPDensity( void ) 
: XppBarGraph( 400, 200, 0, 0, "prob density function" ),
  fP(0) 
{
  XppBarGraph::SetAutoScalingOff();
  XppBarGraph::SetAutoRedrawOnExpose();  
}


// ============================================================================
void VwPDensity::View( StdPDensity& p )  
{        
  fP = &p; 
  XppBarGraph::SetDrawingCoordinates( 0.0, fP->fN.Size(), 0.0, 1.0 );
}


// ============================================================================
void VwPDensity::Update(void)
{
  if(fP)  // If there is a probability density function to view
    {
      fP->UpdateDensity();
      XppBarGraph::Clear();
      XppBarGraph::PlotBarGraph( &(fP->fY[0]), fP->fY.Size() );
      XppBarGraph::Flush();
    }
}











