// ============================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
// ============================================================================
#ifndef __VwPopulationH__
#define __VwPopulationH__

#include "EvPopulation.h"
#include "EvIndividual.h"
#include "EvRealGenome.h"
#include "XppHistogram.h"

// ============================================================================
// VwPopulation provides a view of a EvPopulation. EvPopulation displays 
// a histogram of the performance values the individuals in the population.
// ============================================================================

class VwPopulation : public XppHistogram
{
  public:
    // Specify the EvPopulation to view
    VwPopulation(void);
    void View( EvPopulation< EvIndividual<EvRealGenome> >&);

    // Update the view
    void Update(void);    // Update the population view
  
  private:
    EvPopulation< EvIndividual<EvRealGenome> >* fP;  // Population to inspect
};



#endif
