//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================

#ifndef  __SysPendulumH__
#define  __SysPendulumH__

//============================================================================
// SysPendulum is an  inverted pendulum / cart-pole system
//============================================================================

class SysPendulum
{
  friend class VwPendulum;
  public:
   SysPendulum(void);
   void Reset(double theta, double thetaDot, double x, double xDot);  
   void Step(double force, double stepSize);   

   inline double Theta(void)     const { return (fTheta);     }
   inline double ThetaDot(void)  const { return (fThetaDot);  }  
   inline double ThetaDDot(void) const { return (fThetaDDot); }
   inline double X(void)         const { return (fH);         }
   inline double XDot(void)      const { return (fHDot);      }
   inline double XDDot(void)     const { return (fHDDot);     }
   inline double Force(void)     const { return (fForce);     }

  private:
   double fTheta;          // Angle of pendulum 
   double fThetaDot;       // Rotational velocity of pendulum 
   double fThetaDDot;      // Angular acceleration of pendulum 

   double fH;              // Position of cart  
   double fHDot;           // Velocity of cart  
   double fHDDot;          // Acceleration of cart 

   double fForce;          // Force acting on the cart
};

#endif

