//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved.
//============================================================================
#ifndef __SysNNetworkH__
#define __SysNNetworkH__

//==========================================================================
// A SysNNetwork implements a continuous time neural network.
//==========================================================================
#include <iostream.h>
#include "StdArray.h"
#include "StdMatrix.h"

class SysNNetwork 
{
  public:
    SysNNetwork(int numberOfNodes = 0);  // Create an unconnected network

    void Connect(int i, int j);       // Connect node j to node i
    void Disconnect(int i, int j);    // Disconnect node j from node i

    void Reset(void);                 // Reset to initial state
    void Step(double stepsize);
    
    inline int     Size(void) const     { return (fNumberOfNodes    ); }
    inline double& TimeConstant(int i)	{ return (fTau[i]           ); }
    inline double& Tau(int i)	 	{ return (fTau[i]           ); }
    inline double& Bias(int i)		{ return (fBias[i]          ); }
    inline double& InputScale(int i)    { return (fInputScale[i]    ); }
    inline double& Output(int i)	{ return (fOutput[i]        ); }
    inline double& State(int i)		{ return (fState[i]         ); }
    inline double& ExternalInput(int i) { return (fExternalInput[i] ); }
    inline double& Weight(int i, int j)	{ return (fWeight[i][j]     ); } 

    void Print(ostream&) const;
    friend void LoadState(istream& is, SysNNetwork& n);
    friend void SaveState(ostream& os, SysNNetwork& n);

  protected:
    int fNumberOfNodes;	            // Number of nodes in the network
    StdArray<double> fTau;	    // Time constant of ith node
    StdArray<double> fBias;	    // Bias of ith sigmoid 
    StdArray<double> fInputScale;     // Scaling of the ith external input
    StdArray<double> fOutput;	    // Output of ith node
    StdArray<double> fState;	    // State of the ith node 
    StdArray<double> fExternalInput;  // External input to the ith node
    StdMatrix<int>    fConnect; 	    // Connectivity matrix
    StdMatrix<double> fWeight;	    // Weight matrix
};

ostream& operator << (ostream& os, const SysNNetwork& n);

#endif


