//============================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved.
//============================================================================

#ifndef __SysFullNNetworkH__
#define __SysFullNNetworkH__

// 
// A SysFullNNetwork is a SysNNetwork in which every node is connected to 
// every other node including itself. ie: a fully connected network.
// This class defines a more efficient Step() function than that used
// in the SysNNetwork class.


#include "SysNNetwork.h"

class SysFullNNetwork : public SysNNetwork
{
 public:
  SysFullNNetwork(int numberOfNodes);

  void Step(double stepsize);

 private:
  void Connect(int i, int j);      // These methods are disabled
  void Disconnect(int i, int j);
};


#endif
