//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved.
//============================================================================


#include "SysFullNNetwork.h" 
#include "SysIntegration.h"
#include "SysSigmoid.h"


//============================================================================
SysFullNNetwork::SysFullNNetwork(int numberOfNodes) 
: SysNNetwork( numberOfNodes )
{
   for(int i = 0; i < numberOfNodes; i++)
     for( int j = 0; j< numberOfNodes; j++)
       SysNNetwork::Connect(i,j);              // Connect all the nodes
}   


//============================================================================
void SysFullNNetwork::Step(double stepsize)
{
  double inputsum;  int i, j;
  for (i=0; i<fNumberOfNodes; i++)    // For each node
    {
      // Compute the net input to the node
      inputsum = fInputScale[i] * fExternalInput[i];
      double *w = fWeight[i];    // The ith row of the weight matrix
      for (j=0; j<fNumberOfNodes; j++) 
	inputsum += w[j] * fOutput[j];
      
      // Compute the next state
      fState[i]=Euler(fState[i],(inputsum - fState[i])/fTau[i],stepsize);
    }
  // Compute the outputs
  for (i=0; i<fNumberOfNodes; i++)	
    fOutput[i] = Sigmoid( fState[i] - fBias[i] );
}	
	


