// ===========================================================================
// Copyright (c) 1995 Leslie Picardo, Alan Calvitti, Frank Dellaert.
// All rights reserved. 
// This code borrows from the class designs of Alan Calvitti & Frank Dellaert.
// ===========================================================================

#ifndef __StdVectorH__
#define __StdVectorH__

#include "StdArray.h"

class StdVector : public StdArray<double>
{
  public:
    // Constructors
    StdVector(int size = 0);
    StdVector(double x, double y);            // 2-D vector
    StdVector(double x, double y, double z);  // 3-D vector  

    // Vector math operations
    StdVector& operator+=(const StdVector&);	  
    StdVector& operator-=(const StdVector&);
    StdVector& operator*=(double);
    StdVector& operator/=(double);
    friend StdVector operator+(const StdVector&, const StdVector&);
    friend StdVector operator-(const StdVector&, const StdVector&);
    friend StdVector operator*(const StdVector&, double);
    friend StdVector operator*(double, const StdVector&);
    friend StdVector operator/(const StdVector&, double);
    friend double    operator*(const StdVector&, const StdVector&);

    // Misc
    void Zeros();   // Set each element to zero
    void Ones();    // Set each element to one

    // Special access functions for 2-D and 3-D vectors
    inline double X(void) const { return fX[0]; }
    inline double Y(void) const { return fX[1]; }
    inline double Z(void) const { return fX[2]; }
};

// Non member functions ......................................................

// Printing the vector 
  ostream&  operator << ( ostream&, const StdVector&);

// Saving and retrieving the state of the vector
  void LoadState(istream&, StdVector&);
  void SaveState(ostream&, StdVector&); 

// ...........................................................................

#endif

