//=========================================================================
// Copyright (c) 1995 Leslie Picardo and Alan Calvitti
// All rights reserved
//=========================================================================

#include "StdString.h"
#include "StdAssert.h"


//============================= Constructors =================================
StdString::StdString(const char* s) 
 :StdArray<char>(strlen(s)+1) 
{ strcpy( fX, s); }

StdString::StdString(int n)  
 : StdArray<char>(n+1) 
{ assert(n>=0); strcpy( fX, ""); }

//============================= Assignment ===================================
StdString& StdString::operator = (const char* s)
{
  StdArray<char>::Resize(strlen(s)+1);  // Make enough space
  strcpy( fX, s );                    // Copy the source string
  return (*this);
}

//============================== Concatenation ===============================
StdString operator + (const StdString& s1, const StdString& s2) 
{ 
  StdString tmp(s1.fSize + s2.fSize - 1); // Make space for concatenated string
  strcpy(tmp.fX, s1.fX);                  // Copy the first string
  strcpy(&tmp.fX[s1.fSize-1], s2.fX);     // Cat  the second string
  return tmp;                              
}

StdString& StdString::operator += (const StdString& s) 
{ return( *this = *this + s ); }

//============================== String comparison ===========================
int operator == (const StdString& s1, const StdString& s2) 
{ return ( !strcmp(s1.fX, s2.fX) ); }

int operator != (const StdString& s1, const StdString& s2) 
{ return (  strcmp(s1.fX, s2.fX) ); }


//============================== Stream input and output =====================
istream& operator >> (istream& is, StdString& s)
{
  char buffer[128];  is >> buffer;   // Read string into temporary buffer
  assert( strlen(buffer) < 128 );    // Make sure buffer hasn't overflowed
  
  s = buffer;                       // Assign char* buffer to the source string
  return is;
}

ostream& operator << (ostream& os, const StdString& s)  
{ return (os << s.fX); }









