//============================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
//============================================================================
#ifndef __StdRandomH__
#define __StdRandomH__

#include "StdVector.h"
 
void    RandomSeed(int seed);                      // Seed the random generator
double  UniformRandom(double min, double max);     // Return a uniform random 
double  GaussianRandom(double mean, double variance);// Return a normal random 
int     Probability(double p);          // Returns 1 with probability p, else 0
int     RandomInt(int n);               // Returns a random int in [0, n-1]
int     RandomInt(int min, int max);    // Returns a random int in [min, max]
StdVector RandomUnitVector(int n);      // Return an n-dimensional random 
                                        // unit vector

#endif
