// ===========================================================================
// Copyright (c) 1995 Leslie Picardo. All rights reserved
// ===========================================================================
#ifndef __StdPDensityH__
#define __StdPDensityH__

#include "StdVector.h"


// ==========================================================================
// StdPDensity is used to create an estimate of the probability density
// function of a random variable x from experimental data points.
//
// A StdPDensity is created by specifying the x domain [xmin, xmax] of 
// the probability density function f(x) to be estimated. 
// This range is divided into <numberOfIntervals> equally spaced 
// subdivisions (probability events).
//
// Data points are added to the StdPDensity using the AddDataPoint(x)
// member function. The probability density function value f(x) is 
// estimated from the fraction of data points that lie in the 
// subdivision (event) containing x.
// ==========================================================================


class StdPDensity 
{
  friend class VwPDensity;  // a Viewer for this class
  public:
    StdPDensity(double xmin=-2, double xmax=+2, int numberOfIntervals=1000);
    StdPDensity(istream&);
    
    void AddDataPoint(double x);

    double operator () (double x);
    void SaveTable(ostream&);
    
    friend void LoadState(istream&, StdPDensity&);
    friend void SaveState(ostream&, StdPDensity&);
    
  private:
    double  fXMin, fXMax;        // The domain of the density function
    double  fIntervalSize;       // The size of each subdivision
    StdVector fN;     // fN[i] = The number of datapoints in the ith interval
    StdVector fY;     // fY[i] = f(x) estimate in the ith interval 
    
    int    fNumberOfDataPoints;      // Number of datapoints within domain
    int    fNumberOfDiscardedPoints; // Number of datapoints out of domain
    int    fUpdateFlag;              // Flag used for efficiency
    void   UpdateDensity(void);
};


#endif
