//=========================================================================
// Copyright (c) 1994 Leslie Picardo
// All rights reserved
//=========================================================================
#ifndef  __StdMatrixH__
#define  __StdMatrixH__

#include "fstream.h"
#include "StdAssert.h"

//=========================================================================
// The StdMatrix template class implements a matrix of objects of class ZZ 
// Class ZZ must have a default constructor.
//=========================================================================

template <class ZZ>
class StdMatrix
{
  public:
    // Constructors
    StdMatrix(int rows = 0, int cols = 0);
    StdMatrix(const StdMatrix<ZZ>&);
   ~StdMatrix(void);

    // Assignment
    const StdMatrix<ZZ>& operator= (const StdMatrix<ZZ>&);

    // Access to data 
    inline const ZZ* operator[](int rowIndex) const;
    inline       ZZ* operator[](int rowIndex);
    inline int Rows(void) const; 
    inline int Cols(void) const; 

    // Changing the size
    void Resize(int m, int n);
    void ResizeSave(int m, int n);

    // Printing the array
    void Print(ostream& os) const;
  
  protected:
    int fRows;  // Number of rows
    int fCols;  // Number of columns
    ZZ** fX;    // Matrix of ZZ`s
};


// Non-member functions .....................................................

// Printing the matrix
template<class ZZ> ostream& operator << (ostream&, const StdMatrix<ZZ>&);
template<class ZZ> ofstream& operator << (ofstream&, const StdMatrix<ZZ>&);

// Saving and retrieving the state of the matrix
template<class ZZ> void LoadState(istream&, StdMatrix<ZZ>&);
template<class ZZ> void SaveState(ostream&, StdMatrix<ZZ>&);

template<class ZZ> void LoadState(ifstream&, StdMatrix<ZZ>&);
template<class ZZ> void SaveState(ofstream&, StdMatrix<ZZ>&);


// Inlines ..................................................................

template<class ZZ>
inline const ZZ* StdMatrix<ZZ>::operator[](int i) const 
{ assert((i>=0)&&(i<fRows)); return (fX[i]); }

template<class ZZ>
inline       ZZ* StdMatrix<ZZ>::operator[](int i)       
{ assert((i>=0)&&(i<fRows)); return (fX[i]); }

template<class ZZ> inline int StdMatrix<ZZ>::Rows(void) const 
{ return(fRows);  }
template<class ZZ> inline int StdMatrix<ZZ>::Cols(void) const 
{ return(fCols);  }

#endif

