<HTML>
<HEAD><TITLE> template class StdMatrix&lt;T>    </TITLE></HEAD>

<BODY> 

<H3> Template class StdMatrix&lt;T>  </H3>
<HR>

<DL> 
  <DT> <b> Description: </b>
  <DD> A template class that produces a matrix of objects of class T. 
       Class T must have a default constructor. Matrix elements are
       accessed using the familiar 'C' style [][] indexing mechanism.<BR><BR>
  <DT> <b>Source code: </b>
  <DD> <A HREF="../Include/StdMatrix.h"> StdMatrix.h </A> <BR>
       <A HREF="../Include/StdMatrix.c"> StdMatrix.c </A> <BR><BR>
  <DT> <A HREF ="StdMatrix.e">  <b>Examples: </b></A>
</DL>

<HR>
<P> <img src="images/constructors.gif"> </P>
<DL>
  <DT> <img src="images/yellow-ball-small.gif">
       <b><CODE> StdMatrix(int rows = 0, int cols = 0);     </CODE></b> 
  <DD>  Create a matrix with the specified number of
        <b><CODE>rows</CODE></b> and <b><CODE>cols</CODE></b>.
</DL>

<P> <img src="images/methods.gif"> </P>
 <DL> 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline const ZZ* operator[](int i) const; </CODE></b> 
  <DD>  Get a pointer to  the <b><CODE>i'</CODE></b>th row of the matrix
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline       ZZ* operator[](int rowIndex); </CODE></b> 
  <DD>  Get a pointer to  the <b><CODE>i'</CODE></b>th row of the matrix 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline int Rows(void) const;</CODE></b> 
  <DD> Get the number of rows in the matrix
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline int Cols(void) const;</CODE></b> 
  <DD> Get the number of columns in the matrix <BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>void Resize(int m, int n); </CODE></b> 
  <DD> Resize the matrix to <b><CODE>m</CODE></b> rows and 
       <b><CODE>n</CODE></b> columns 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>void ResizeSave(int m, int n); </CODE></b> 
  <DD> Resize the matrix to <b><CODE>m</CODE></b> rows and 
       <b><CODE>n</CODE></b> columns. The contents of the previous
       matrix are copied over to the resized matrix. <BR><BR>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>void Print(ostream& os) const; </CODE></b> 
  <DD> Print the matrix on the ostream <b><CODE>os</CODE></b><BR><BR>
</DL>

<P> <img src="images/functions.gif"> </P>
<DL> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> template<class ZZ> ostream& operator << (ostream& os, const StdMatrix<ZZ>& m);   </CODE></b>
 <DD> Print the matrix <b><CODE>m</CODE></b> on the ostream <b><CODE>os</CODE></b>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>template<class ZZ> ofstream& operator << (ofstream& ofs, const StdMatrix<ZZ>& m);    </CODE></b>
 <DD> Print the matrix <b><CODE>m</CODE></b> on the ofstream <b><CODE>ofs</CODE></b> <BR><BR>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> template<class ZZ> void SaveState(ostream& os, StdMatrix<ZZ>& m);    </CODE></b>
 <DD> Save the state of the matrix <b><CODE>m</CODE></b> on the ostream <b><CODE>os</CODE></b>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> template<class ZZ> void LoadState(istream& is, StdMatrix<ZZ>& m);   </CODE></b>
 <DD> Load the state of the matrix <b><CODE>m</CODE></b> from the istream <b><CODE>is</CODE></b> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>  template<class ZZ> void SaveState(ofstream& ofs, StdMatrix<ZZ>& m);  </CODE></b>
 <DD> Save the state of the matrix <b><CODE>m</CODE></b> on the ofstream <b><CODE>ofs</CODE></b> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>template<class ZZ> void LoadState(ifstream& ifs, StdMatrix<ZZ>& m);   </CODE></b>
 <DD> Load the state of the matrix <b><CODE>m</CODE></b> from the ifstream <b><CODE>ifs</CODE></b>  <BR><BR>

</DL>


<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


