<HTML>
<HEAD><TITLE> class StdBitString    </TITLE></HEAD>

<BODY> 

<H3> Class StdBitString  </H3>
<HR>  

<DL> 
  <DT> <b> Description: </b>
  <DD> A class that implements an array of bits. eg - 0101001. 
       The bits are numbered from left to right starting with bit 0  <BR><BR>
  <DT> <b>Source code: </b>
  <DD> <A HREF="../Include/StdBitString.h"> StdBitString.h  </A> <BR>
       <A HREF="../Include/StdBitString.c"> StdBitString.c </A> <BR><BR>
  <DT> <A HREF ="StdBitString.e"> <b>Examples: </b> </A>
</DL>

<HR>
<P> <img src="images/constructors.gif"> </P>
<DL>
  <DT> <img src="images/yellow-ball-small.gif">
       <b><CODE> StdBitString(int numberOfBits = 1); </CODE></b> 
  <DD> Create a bitstring with <b><CODE>numberOfBits</CODE></b>
       bits. The bits are uninitialized.
  <DT> <img src="images/yellow-ball-small.gif">
       <b><CODE> StdBitString(StdBitString& s, int bitLow, int bitHigh); </CODE></b> 
  <DD> Create a copy of the substring in StdBitString <b><CODE>s</CODE></b> from bits
       <b><CODE>bitLow</CODE></b> to <b><CODE>bitHigh</CODE></b>. 
</DL>

<P> <img src="images/methods.gif"> </P>
 <DL> 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>  inline int NumberOfBits(void) const;</CODE></b> Get the number of bits in the bitstring.   <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline int Size(void) const;</CODE></b> Get the number of bits in the bitstring. <BR><BR>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> inline int operator[] (int i) const;</CODE></b> 
  <DD> Read the i'th bit. Returns 0 if bit i is zero. Returns ~0 if bit i is one. <BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>  inline void Set(int i); </CODE></b>    Set the i'th bit to one.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>  inline void Clear(int i);</CODE></b>    Set the i'th bit to zero.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>  inline void Invert(int i);</CODE></b>    Toggles the i'th bit. <BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>inline void Set(void); </CODE></b>     Set all the bits to one. 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>inline void Clear(void); </CODE></b>    Set all the bits to zero. 
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>inline void Invert(void) </CODE></b>    Toggles all the bits. <BR><BR>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>inline StdBitString& operator &= (const StdBitString& s); </CODE></b> 
        logical AND with <b><CODE>s</CODE></b>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>inline StdBitString& operator |= (const StdBitString& s); </CODE></b> 
        logical OR with <b><CODE>s</CODE></b>
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>inline StdBitString& operator ^= (const StdBitString& s); </CODE></b> 
        logical XOR with <b><CODE>s</CODE></b>
 <BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>void Resize(int numberOfBits); </CODE></b> 
  <DD> Resize the bitstring to the specified size.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE>void ResizeSave(int numberOfBits); </CODE></b> 
  <DD> Resize the bitstring to the specified size. The contents of the previous bitstring 
       are copied to the resized bitstring.  <BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> StdBitString SubString(int bitLow, int bitHigh);</CODE></b> 
  <DD> Return the substring between bits <b><CODE>bitLow</CODE></b>and <b><CODE>bitHigh</CODE></b><BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> void BinaryToGrey(void) </CODE></b> 
  <DD> Treat the bitstring as a binary code and convert it to its grey code equivalent.
  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> void GreyToBinary(void); </CODE></b> 
  <DD> Treat the bitstring as a grey code and convert it to its binary code equivalent.<BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b><CODE> void Print(ostream& os) const;</CODE></b> 
  <DD> Print the bitstring on the ostream os.
</DL>

<P> <img src="images/functions.gif"> </P>
<DL> 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> StdBitString operator & (const StdBitString& x, const StdBitString& y); </CODE></b>
 <DD> Return the logical AND of bitstrings x and y. 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> StdBitString operator | (const StdBitString& x, const StdBitString& y); </CODE></b>
 <DD> Return the logical OR of bitstrings x and y. 
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> StdBitString operator ^ (const StdBitString& x, const StdBitString& y); </CODE></b>
 <DD>Return the logical XOR of bitstrings x and y.  <BR><BR>

 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>  ostream& operator << (ostream& os, const StdBitString& b);  </CODE></b>
 <DD> Print the bitstring <b><CODE>b</CODE></b> on the ostream <b><CODE>os</CODE></b> <BR><BR>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE>void SaveState(ostream& os, StdBitString& b);    </CODE></b>
 <DD> Save the state of the bitstring <b><CODE>b</CODE></b> on the ostream <b><CODE>os</CODE></b>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> void LoadState(istream& is, StdBitString& b);   </CODE></b>
 <DD> Load the state of the bitstring <b><CODE>b</CODE></b> from the istream <b><CODE>is</CODE></b>
 <BR><BR>

 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> void ConvertBinaryToGrey(const StdBitString& binary, StdBitString& grey); </CODE></b>
 <DD> Replace bitstring <b><CODE>grey</CODE></b> with the grey code equivalent of the binary code
      in bitstring <b><CODE>binary</CODE></b>.
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> void ConvertGreyToBinary(const StdBitString& grey, StdBitString& binary );   </CODE></b>
 <DD> Replace bitstring <b><CODE>binary</CODE></b> with the binary code equivalent of the grey code
      in bitstring <b><CODE>grey</CODE></b>.  <BR><BR>

 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> double ConvertBinaryToDecimal(const StdBitString& b);   </CODE></b>
 <DD> Return the decimal value of the binary coded bitstring <b><CODE>b</CODE></b>
 <DT><img src="images/cyan-ball-small.gif" >
    <b><CODE> double ConvertBinaryToDecimal(const StdBitString& b, int bitLow, int bitHigh); </CODE></b>
 <DD> Return the decimal value of the binary coded substring in bitstring <b><CODE>b</CODE></b> 
      from bits <b><CODE>bitLow</CODE></b> to <b><CODE>bitHigh</CODE></b> <BR><BR>
</DL>



<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


