<!DOCTYPE HTML SYSTEM "html.dtd">
<HTML>
<HEAD><TITLE> template class StdArray&lt;T> </TITLE></HEAD>

<BODY> 

<H3>Template class StdArray&lt;T>  </H3>
<HR>

<DL> 
  <DT> <b> Description: </b>
  <DD> The StdArray&lt;T> template lets you create an array of objects
       of class T.  Elements of the array can be accessed using the familiar
       'C' style array indexing mechanism.  Array elements begin at index 0 and
       are accessed using the [] operator. The class T must have a
       default constructor and a valid assignment operator. <BR><BR>
  <DT> <b>Source code: </b>
  <DD> <A HREF="../Include/StdArray.h"> StdArray.h </A> <BR>
       <A HREF="../Include/StdArray.c"> StdArray.c </A> <BR><BR>
  <DT> <A HREF ="StdArray.e">  <b>Examples: </b></A>
</DL>

<HR>
<P> <img src="images/constructors.gif"> </P>
<DL>
  <DT> <img src="images/yellow-ball-small.gif">
       <b> <CODE> StdArray(int size = 0); </CODE> </b> 
  <DD>  Create an array of the specified length. Each object in the
        array is constructed using its default constructor.
</DL>

<P> <img src="images/methods.gif"> </P>
 <DL> 
  <DT> <img src="images/red-ball-small.gif">
       <b> <CODE>inline int Size(void) const;  </CODE> </b> 
  <DD>  Get the size (number of elements) of the array
  <DT> <img src="images/red-ball-small.gif">
       <b> <CODE>inline const T& operator [] (int i) const;  </CODE> </b> 
  <DD>  Read the i'th element of the array
  <DT> <img src="images/red-ball-small.gif">
       <b> <CODE>inline  T& operator [] (int i);  </CODE> </b> 
  <DD>  Write to the i'th element of the array <BR><BR>

  <DT> <img src="images/red-ball-small.gif">
       <b> <CODE> void Resize(int newsize); </CODE> </b> 
  <DD> Change the size of the array
  <DT> <img src="images/red-ball-small.gif">
       <b> <CODE> void ResizeSave(int newsize); </CODE> </b> 
  <DD> Change the size of the array. Elements of the previous array
       are copied over to the resized array. <BR><BR>
  <DT> <img src="images/red-ball-small.gif">
       <b> <CODE> void Print(ostream& os) const; </CODE> </b> 
  <DD> Print the elements of the array on the ostream. 
</DL>

<P> <img src="images/functions.gif"> </P>
<DL> 
  <DT> <img src="images/cyan-ball-small.gif" >
       <b><CODE> template&lt;class T>  ostream&  operator << 
                ( ostream& os, const StdArray&lt;T>& a); </CODE></b>
  <DD> Print the array <b><CODE>a</CODE></b> on the ostream <b><CODE>os</CODE></b>
  <DT> <img src="images/cyan-ball-small.gif" >
       <b><CODE> template&lt;class T>  ofstream&  operator << 
                ( ofstream& ofs, const StdArray&lt;T>& a); </CODE></b>
  <DD> Print the array <b><CODE>a</CODE></b> on the ofstream <b><CODE>ofs</CODE></b><BR><BR>

  <DT> <img src="images/cyan-ball-small.gif" >
       <b><CODE>template&lt;class T>  void SaveState(ostream& os, StdArray&lt;T>& a); </CODE></b>
  <DD> Save the state of the array <b><CODE>a</CODE></b> on the ostream <b><CODE>os</CODE></b>
  <DT> <img src="images/cyan-ball-small.gif" >
       <b><CODE>template&lt;class T>  void SaveState(ofstream& ofs, StdArray&lt;T>& a); </CODE></b>
  <DD> Save the state of the array <b><CODE>a</CODE></b> on the ofstream <b><CODE>ofs</CODE></b>
  <DT> <img src="images/cyan-ball-small.gif" >
       <b><CODE>template&lt;class T>  void LoadState(istream& is, StdArray&lt;T>& a); </CODE></b>
  <DD> Load the state of the array <b><CODE>a</CODE></b> from the istream <b><CODE>is</CODE></b>
  <DT> <img src="images/cyan-ball-small.gif" >
       <b><CODE>template&lt;class T>  void LoadState(ifstream& ifs, StdArray&lt;T>& a); </CODE></b>
  <DD> Load the state of the array <b><CODE>a</CODE></b> from the ifstream <b><CODE>ifs</CODE></b>
</DL>

<HR>

<EM>
 Copyright (c) 1995 Leslie Picardo 
 <A HREF="mailto:picardo@alpha.ces.cwru.edu"> (picardo@alpha.ces.cwru.edu)</A>  <BR>
 All rights reserved              
</EM>
<HR>



</BODY>
</HTML>


