// ===========================================================================
// Copyright (c) 1995 Leslie Picardo, Alan Calvitti, Frank Dellaert.
// All rights reserved. 
// This code borrows from the class design  of Alan Calvitti & Frank Dellaert.
// ===========================================================================

#include "StdVector.h"

//============================================================================
StdVector::StdVector(int size) : StdArray<double>(size) 
{ }

//============================================================================
StdVector::StdVector(double x, double y) : StdArray<double>(2)
{ fX[0] = x;  fX[1] = y; }

//============================================================================
StdVector::StdVector(double x, double y, double z) : StdArray<double>(3)
{ fX[0] = x;  fX[1] = y;  fX[2] = z; }



//============================================================================
StdVector& StdVector::operator+=(const StdVector& s)
{
  assert(fSize == s.fSize);
  for(int i=0;i<fSize;i++) fX[i] += s.fX[i];
  return (*this);
}

//============================================================================
StdVector& StdVector::operator-=(const StdVector& s)
{
  assert(fSize == s.fSize);
  for(int i=0;i<fSize;i++) fX[i] -= s.fX[i];
  return (*this);
}

//============================================================================
StdVector& StdVector::operator*=(double x)
{
  for(int i=0;i<fSize;i++)   fX[i] *= x;
  return (*this);
}

//============================================================================
StdVector& StdVector::operator/=(double x)
{
  assert(x != 0.0);
  for(int i=0;i<fSize;i++)  fX[i] /= x;
  return (*this);
}

//============================================================================
StdVector operator+(const StdVector& s1, const StdVector& s2)
{
  assert(s1.fSize == s2.fSize);
  int size = s1.fSize;  StdVector tmp(size);
  for(int i=0;i<size;i++)    tmp.fX[i] = s1.fX[i] + s2.fX[i];
  return tmp;
}

//============================================================================
StdVector operator-(const StdVector& s1, const StdVector& s2)
{
  assert(s1.fSize == s2.fSize);
  int size = s1.fSize;  StdVector tmp(size);
  for(int i=0;i<size;i++)    tmp.fX[i] = s1.fX[i] - s2.fX[i];
  return tmp;
}

//============================================================================
StdVector operator*(const StdVector& s, double x)
{
  int size = s.fSize;  StdVector tmp(size);
  for(int i=0;i<size;i++)   tmp.fX[i] = s.fX[i] * x;
  return tmp;
}

//============================================================================
StdVector operator*(double x, const StdVector& s)
{
  int size = s.fSize;  StdVector tmp(size);
  for(int i=0;i<size;i++)   tmp.fX[i] = s.fX[i] * x;
  return tmp;
}

//============================================================================
StdVector operator/(const StdVector& s, double x)
{
  assert(x != 0.0);
  int size = s.fSize;  StdVector tmp(size);
  for(int i=0;i<size;i++)   tmp.fX[i] = s.fX[i] / x;
  return tmp;
}

//============================================================================
double operator*(const StdVector& s1, const StdVector& s2)
{
  assert(s1.fSize == s2.fSize);
  int size = s1.fSize;  double tmp = 0.0;
  for(int i=0;i<size;i++)    tmp += s1.fX[i] * s2.fX[i];
  return tmp;
}


void StdVector::Zeros() { for(int i=0; i<fSize;i++) fX[i] = 0.0; }
void StdVector::Ones()  { for(int i=0; i<fSize;i++) fX[i] = 1.0; }



//============================================================================
ostream& operator << (ostream& os, const StdVector& a)
{
  a.Print(os);   // Print the vector
  return(os);
}

//============================================================================
void LoadState(istream& is, StdVector& a)
{
  StdArray<double>& base = a;   // Convert to base class
  LoadState(is, base);        // Load base 
}

//============================================================================
void SaveState(ostream& os, StdVector& a) 
{
  StdArray<double>& base = a;   // Convert to base class
  SaveState(os, base);        // Save base 
}







