// ===========================================================================
// Copyright (c) 1995 Leslie Picardo.  All rights reserved
// ===========================================================================

#ifndef __StdTypesH__
#define __StdTypesH__

#include <iostream.h>

// The LoadState and SaveState functions are used to simulate object
// persistance. This allows any object to be saved and later retrieved
// from any iostream. In order to do this the LoadState and SaveState
// functions are overloaded for each class including the built builtin
// data types. These are the declarations for the builtin data types


void LoadState(istream& is, double& x);
void LoadState(istream& is, float& x); 
void LoadState(istream& is, short& x); 
void LoadState(istream& is, int&  x); 
void LoadState(istream& is, char& x);  
void LoadState(istream& is, unsigned short& x); 
void LoadState(istream& is, unsigned int&  x); 
void LoadState(istream& is, unsigned char& x);  
void LoadState(istream& is, char* x);  

void SaveState(ostream& os, double& x);
void SaveState(ostream& os, float& x); 
void SaveState(ostream& os, short& x); 
void SaveState(ostream& os, int&  x); 
void SaveState(ostream& os, char& x); 
void SaveState(ostream& os, unsigned short& x); 
void SaveState(ostream& os, unsigned int&  x); 
void SaveState(ostream& os, unsigned char& x); 
void SaveState(ostream& os, char* x); 

#endif

