//=========================================================================
// Copyright (c) 1995 Leslie Picardo and Alan Calvitti
// All rights reserved
//=========================================================================

#ifndef __StdStringH__
#define __StdStringH__

#include <iostream.h>
#include "StdArray.h"

//=========================================================================
// StdString implements string operations
//=========================================================================

class StdString : private StdArray<char>
{
  public:
    // Constructors
    StdString(int size);
    StdString(const char* s = "");              
   
    // Assignment  
    StdString& operator = (const char* cp); 

    // Concatenation
    friend StdString operator + (const StdString& s1, const StdString& s2);  
    StdString& operator += (const StdString&);     
    
    // Type conversion
    operator char*() const {return fX;}   

    // Access to data
    inline const char& operator[] (int i) const;
    inline       char& operator[] (int i);
    inline int Size() const;

    // String comparison
    friend int operator == (const StdString& s1, const StdString& s2); 
    friend int operator != (const StdString& s1, const StdString& s2); 

    // Printing and reading a string
    friend istream& operator >> (istream&, StdString&);
    friend ostream& operator << (ostream&, const StdString&);
};




// Inlines ...................................................................

inline const char& StdString::operator[] (int i) const 
{assert(((i>=0)&&(i<fSize-1))); return  fX[i];} 

inline char& StdString::operator[] (int i)       
{assert(((i>=0)&&(i<fSize-1))); return  fX[i];}

inline int StdString::Size() const 
{ return fSize; }    

#endif
